<?php
// ++=========================================================================++
// || vBadvanced CMPS v4.1.2 (vB 4.0 - 4.1) - 137094
// ||  2003-2011 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 10:06, Wed Sep 7th 2011
// || 520137094_407329059488
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE & ~8192);

$pages =& $vbulletin->adv_pages;

// ##### strripos function for PHP4- ##########################################
if (!function_exists('strripos'))
{
	function strripos($haystack, $needle, $offset = 0)
	{
		if ($offset < 0)
		{
			$temp_cut = strrev(substr($haystack, 0, abs($offset)));
		}
		else
		{
			$temp_cut = strrev(substr($haystack, $offset));
		}

		$pos = strlen($haystack) - (strpos($temp_cut, strrev($needle)) + $offset + strlen($needle));

		if ($pos == strlen($haystack))
		{
			$pos = 0;
		}

		if (strpos($temp_cut, strrev($needle)) === false)
		{
			return false;
		}
		return $pos;
	}
}

// ##### Order Site Naviation links ###########################################
function order_site_nav($a, $b)
{
	return ($a['order'] < $b['order']) ? -1 : 1;
}

// ##### Construct Global Templates Function ##################################
if (!function_exists('construct_global_templates'))
{
	function construct_global_templates($mod)
	{
		global $bootstrap;

		if ($mod['inctype'] == 'php_file' AND !empty($mod['templatelist']))
		{
			$bootstrap->cache_templates = array_merge($bootstrap->cache_templates, $mod['templatelist']);
		}
		else if ($mod['inctype'] == 'template' AND $mod['filename'])
		{
			$bootstrap->cache_templates[] = 'adv_portal_' . $mod['filename'];
		}

		if ($mod['altshell'])
		{
			$bootstrap->cache_templates[] = $mod['altshell'];
		}
	}
}

// ##### Check Module Permissions #############################################
function can_view_cmps_mod($mod)
{
	global $vbulletin;
	
	if ($mod['inctype'] == 'custom'
		OR ($mod['userperms'] AND array_intersect($vbulletin->userinfo['usergrouparray'], $mod['userperms']))
	)
	{
		return true;
	}
	
	return false;
}

// ##### Strip Body Tag #######################################################
function strip_body_tags($content)
{
	global $header, $navbar, $footer, $headinclude, $spacer_open, $spacer_close;

	$bodytag = strpos($content, '<body');

	if ($bodytag)
	{
		$bodycut = strpos($content, '>', $bodytag);

		// Find and add any js tags that might be in the content's <head> tag
		preg_match_all('@<script[^>]*?>.*?</script>@si', str_replace($headinclude, '', substr($content, 0, $bodycut)), $jstags);

		if (!empty($jstags[0]))
		{
			foreach ($jstags[0] AS $addtag)
			{
				$headinclude .= $addtag;
			}
		}

		$content = substr($content, $bodycut + 1);
	}

	if ($vbulletin->debug)
	{
		$bodyendcut = strpos($content, '<!--start debug html-->');
	}

	if (!$bodyendcut)
	{
		$bodyendcut = strpos($content, '</body>');
	}

	if ($bodyendcut)
	{
		$content = substr($content, 0, $bodyendcut);
	}

	return str_replace(
		array($header, $navbar, $footer, $headinclude, $spacer_open, $spacer_close),
		'',
		$content
	);
}

// ##### Function to Print The Page Out #######################################
function print_portal_output(&$home, $nonindex = false, $from_print_output = false)
{
	global $vba_options, $pages, $vba_style, $cmps_options, $home, $modules, $vba_modcols, $vba_cssinclude;
	global $vba_dyna, $vba_dyna_temps, $dyna_default, $dyna_special_temp_default, $vba_dyna_inst;
	global $vba_shellint, $vba_php_modint, $vba_bbc_modint, $vba_initload;
	global $adv_forumperms, $adv_canviewforums, $adv_canviewforumscontent, $vba_colwidths;
	global $mod_options, $modcol, $onlineprocesssed, $vb_read_cookies;

	global $vbulletin, $vbphrase, $stylevar, $show, $pagetitle, $vbcollapse, $tempusagecache;
	global $db, $permissions, $bgclass, $altbgclass, $bbcode_parser, $imodcache, $foruminfo;
	global $admincpdir, $modcpdir;

	global $header, $headinclude, $footer, $navbar, $navbits, $spacer_open, $spacer_close, $gobutton;
	global $ad_location, $notices, $notifications_total, $notifications_menubits, $pmbox, $template_hook;

	global $_CALENDARHOLIDAYS, $eventcache, $days, $months, $calendarinfo, $birthdaycache, $doublemonth, $doublemonth1, $doublemonth2, $_CALENDAROPTIONS;

	// ##### Advanced page options - set before globalizing variables 
	if (!empty($pages['advanced']))
	{
		foreach ($pages['advanced'] AS $sgroup => $sgvalue)
		{
			foreach ($sgvalue AS $vname => $valu)
			{
				switch ($sgroup)
				{
					case 'adv_portal_main':
						$vba_options[$vname] = $valu;
					break;

					case 'adv_portal_style':
						$vba_style[$vname] = $valu;
					break;

					default:
						$cmps_options[$sgroup][$vname] = $valu;
				}
			}
		}
	}

	// Disable the "Forum Component URL" since it only causes issues with double URL's
	$vbulletin->options['vbforum_url'] = '';

	// Portal global output variables
	if (!empty($vba_options['portal_outputglobals']))
	{
		if (!is_array($vba_options['portal_outputglobals']))
		{
			$vba_options['portal_outputglobals'] = explode("\r\n", $vba_options['portal_outputglobals']);
		}
	
		foreach ($vba_options['portal_outputglobals'] AS $glob)
		{
			global ${$glob};
		}
	}

	$pagecache =& $vbulletin->adv_portal_page;

	// Page title
	if ($pages['name'] == 'home' AND THIS_SCRIPT == 'adv_index')
	{
		$pagetitle = $vbulletin->options['hometitle'];
	}
	else if (!$pagetitle)
	{
		$pagetitle = $pages['title'];
	}

	// Navbar
	if ($vba_style['portal_shownavbar'] AND empty($navbar))
	{
		if ($pages['name'] != 'home')
		{
			if ($pages['parentlist'])
			{
				foreach (array_reverse(explode(',', $pages['parentlist'])) AS $key => $parent)
				{
					if ($parent != $pages['pageid'])
					{
						$navpagename = $pagecache[$parent]['name'];
						$navpagelink = $vba_options['portal_homeurl'] . $vbulletin->session->vars['sessionurl_q'] . ($navpagename != 'home' ? '?' . $vba_options['portal_pagevar'] . '=' . $navpagename : '');
						$navbits[$navpagelink] = $pagecache[$parent]['title'];
					}
				}
			}
		}

		// Kill the navbits on the search into page so the navbars will match up
		if (THIS_SCRIPT == 'search' AND $_REQUEST['do'] == 'intro')
		{
			$navbits = array();
		}

		$navbits[''] = $pagetitle;

		$navbar = render_navbar_template(construct_navbits($navbits));
	}
	else if (!$vba_style['portal_shownavbar'])
	{
		$navbar = '';
	}

	// vBa Dynamics Replacements
	if (!empty($vba_dyna_temps) AND $vba_options['dyna_version'] != '2.1.2')
	{
		
		foreach ($vba_dyna_temps AS $dyna_temp)
		{
			vba_template_alter(
				$dyna_temp,
				array(
					'"\' . $entry[\'url\']',
					'"\' . $entry[\'caturl\']',
					'"\' . $entry[\'lastposturl\']',
					'"\' . $modcat[\'caturl\']',
					'"\' . $post[\'url\']',
					'"attachment.php',
					'"external.php',
					'"guestbook.php',
					'"image.php',
					'"images/',
					'"index.php',
					'"manageattach.php',
					'"managecats.php',
					'"misc.php',
					'"moderate.php',
					'"newentry.php',
					'"newreply.php',
					'"search.php',
					'"sendmessage.php',
					'"showpost.php',
					'<img src="images/caticon'
				),
				array(
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/\' . $entry[\'url\']',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/\' . $entry[\'caturl\']',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/\' . $entry[\'lastposturl\']',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/\' . $modcat[\'caturl\']',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/\' . $post[\'url\']',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/attachment.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/external.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/guestbook.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/image.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/images/',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/index.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/manageattach.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/managecats.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/misc.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/moderate.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/newentry.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/newreply.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/search.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/sendmessage.php',
					'"\' . $vba_options[\'dyna_homeurl\'] . \'/showpost.php',
					'<img src=\"$vba_options[\'dyna_homeurl\'] . \'/\' . images/caticon'
				)
			);
		}
	
		if (!empty($vba_dyna_inst))
		{
			$dyna_instance = $vba_dyna_inst[0];
			$headinclude .= '<script type="text/javascript" src="' . $vbulletin->options[$dyna_instance . '_dyna_homeurl'] . '/clientscript/vba_dyna_global.js"></script>
	<script type="text/javascript">
	<!--
		var DYNA_HOMEURL = \'' . $vbulletin->options[$dyna_instance . '_dyna_homeurl'] . '\';
	-->
	</script>';

		}
	}

	if (!USE_VBA_HOMECACHE)
	{
		// Find the column widths for dynamic modules
		$vba_colwidths['left'] = ($show['left_column']) ? $vba_style['portal_leftcolwidth'] : 0;
		$vba_colwidths['right'] = ($show['right_column']) ? $vba_style['portal_rightcolwidth'] : 0;
		
		// Auto or fixed number
		if ($vbulletin->stylevars['doc_maxWidth']['size'] == 'auto' OR $vbulletin->stylevars['doc_maxWidth']['units'] != '%')
		{
			$vba_colwidths['center'] = intval(
				($vbulletin->stylevars['doc_maxWidth']['size'] == 'auto'
					? 900
					: intval($vbulletin->stylevars['doc_maxWidth']['size'])
				) - $vba_colwidths['left'] - $vba_colwidths['right']
			);
		}
		// Percentage
		else
		{
			$vba_colwidths['center'] = round(($vbulletin->stylevars['doc_maxWidth']['size'] * 9) - $vba_colwidths['left'] - $vba_colwidths['right']);
		}

		// Reload BB code parser here if necessary since it could be unset in member.php or usercp.php
		if ($vba_initload & $vba_php_modint['load_bbcode_parser'] AND !isset($bbcode_parser))
		{
			require_once(DIR . '/includes/class_bbcode.php');

			$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
			$bbcode_parser->tag_list['no_option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);
			$bbcode_parser->tag_list['no_option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);
			$bbcode_parser->tag_list['option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
			$bbcode_parser->tag_list['option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
			$bbcode_parser->unsetattach = true;

			// Disable PHP modules function since $bbcode_parser can't be globalized at this point
			$vba_options['portal_use_module_function'] = false;
		}

		// Set for recent threads mod here instead of in the file, incase multiple copies are enabled
		$vb_read_cookies = array();

		// Set here for consistancy, incase they've already been set within a file
		$bgclass = 'blockrow';
		$altbgclass = 'blockrow';

		$getmemory = ($vbulletin->debug AND function_exists('memory_get_usage')) ? true : false;

		// Process Active Modules
		if (!empty($pages['modules']))
		{
			if ($vbulletin->debug AND $_REQUEST['explain'])
			{
				$scriptstarted = explode(' ', TIMESTART);
				$scriptstarted = $scriptstarted[0] + $scriptstarted[1];
			}

			foreach ($vba_options['portal_column_array'] AS $modcol => $colname)
			{
				if (empty($pages['modules'][$modcol]))
				{
					if ($show['customizepage'])
					{
						$show[$colname . '_column'] = true;
						$home[$vba_modcols[$modcol] . 'blocks'] = '<ul id="vba_ul_' . $modcol . '" class="draglist"></ul>';
					}
					continue;
				}
				
				foreach ($pages['modules'][$modcol] AS $modid => $modorder)
				{
					$mods =& $vbulletin->adv_modules[$modid];

					if ($vbulletin->debug AND $_REQUEST['explain'])
					{
						$processtitle = $mods['title'];
						echo '<div class="explain"><div class="explaintitle">Processing Module: ' . $mods['title'] . '</div><div class="explainbody">';

						$starttime = explode(' ', microtime());
						$starttime = $starttime[0] + $starttime[1] - $scriptstarted;
						$startqueries = $vbulletin->db->querycount;
						$startquerytime = $vbulletin->db->time_total;

						if ($getmemory)
						{
							$memoryusagestart = memory_get_usage();
						}
					}

					if ($stylevar['oldcellpadding'])
					{
						$stylevar['cellpadding'] = $stylevar['oldcellpadding'];
						$stylevar['oldcellpadding'] = '';
					}

					$mod_options = $cmps_options['adv_portal_' . $mods['identifier']];

					// Dynamics module
					if ($mods['dyna_prefix'] AND $vba_dyna->prefix != $mods['dyna_prefix'])
					{
						// Need to reset the special template values
						if ($mods['dyna_prefix'] == 'adv_dyna')
						{
							foreach ($dyna_special_temp_default AS $dyna_tempname)
							{
								$vbulletin->$dyna_tempname = $dyna_default[$dyna_tempname];
							}
						}
						$vba_dyna->prefix = $mods['dyna_prefix'];
						$vba_dyna->tableprefix = TABLE_PREFIX . $vba_dyna->prefix . '_';

						convert_prefixed_datastore($mods['dyna_prefix']);

						$vba_options = array_merge($vba_options, $vbulletin->adv_dyna_opts);
						$vba_options['dyna_lightbox'] = false; // disable the lightbox since it'll point to vB's attachment.php

						fetch_option_phrases();

						$vba_dyna->default_permissions();
						$vba_dyna->fetch_category_perms();

						// Change the DYNA_HOMEURL javascript var
						$mods['formcode'] .= "\r\n<script type=\"text/javascript\">\r\n<!--\r\nvar DYNA_HOMEURL = \"" . $vbulletin->options[$vba_dyna->prefix . '_dyna_homeurl'] . "\";\r\n-->\r\n</script>\r\n";
					}

					if ($show['customizepage'])
					{
						$mods['formcode'] = '';
						$mods['link']	= '';
					}

					// Set $getbgrow just incase it's still used anywhere
					exec_switch_bg();
					$getbgrow =& $bgclass;

					$mods['collapse'] = $mods['modid'];

					$show['divrow'] = false;
					$show['table'] = ($mods['useshell'] & $vba_shellint['table']);
					$show['endform'] = false;

					// Link (placed before the switch() for modules that dynamically set a link)
					if ($mods['link'])
					{
						eval('$mods[\'link\'] = "' . addslashes($mods['link']) . '";');
					}

					switch ($mods['inctype'])
					{
						// PHP File Module
						case 'php_file':

							if ($vba_options['portal_use_module_function'])
							{
								fetch_vba_module($mods);
							}
							else if ($mods['options'] & $vba_php_modint['clean_output'])
							{
								ob_start();
								require(DIR . '/' . ($mods['dyna_prefix'] ? 'vba_dyna_' : '') . 'modules/' . $mods['filename']);
								$home[$modid]['content'] = ob_get_contents();
								ob_end_clean();
							}
							else
							{
								require(DIR . '/' . ($mods['dyna_prefix'] ? 'vba_dyna_' : '') . 'modules/' . $mods['filename']);
							}
						break;

						// Template Module
						case 'template':
							$templater = vB_Template::create('adv_portal_' . $mods['filename']);
							$home[$mods['modid']]['content'] = $templater->render();
						break;

						// BB Code Module
						case 'bb_code':
							$home[$modid]['content'] =& $mods['code_parsed'];
							$show['divrow'] = true;
						break;

						// ##### Custom page content
						case 'custom':
							$mods['useshell'] = ($pages['type'] == 'module') ? false : $pages['useshell'];
							$mods['title'] = ($pages['custom_title']) ? $pages['custom_title'] : $pages['title'];
							$mods['colspan'] = $pages['colspan'];

							switch ($pages['type'])
							{
								// PHP File page
								case 'php_file':
									// Processed outside of the function now
								break;

								// HTML File Page
								case 'html_file':

									if (function_exists('file_get_contents'))
									{
										$home[$modid]['content'] = strip_body_tags(file_get_contents($pages['template']));
									}
									else
									{
										if ($handle = fopen($pages['template'], 'r'))
										{
											$home[$modid]['content'] = strip_body_tags(fread($handle, filesize($pages['template'])));
											fclose($handle);
										}
									}

								break;

								// Template page
								case 'template':
									if ($pages['template'])
									{
										$templater = vB_Template::create($pages['template']);
										$templater->register('mods', $mods);
										$templater->register('pages', $pages);
										$home[$modid]['content'] = $templater->render();
										$home[$modid]['content'] = strip_body_tags($home[$modid]['content']);
									}
								break;

								// BB code page
								case 'bb_code':
									$home[$modid]['content'] = $bbcode_parser->do_parse(
										$pages['template'],
										$cmps_options['custompage']['allow_html'],
										$cmps_options['custompage']['allow_smilies'],
										1,
										$cmps_options['custompage']['allow_image_code'],
										1
									);
									$show['divrow'] = true;
									$mods['inctype'] = 'bb_code'; // set for the wrapper template
								break;

								// Custom content from another page
								case 'module':
									if ($nonindex)
									{
										// Integrated content replacements
										$bodytag = strpos($nonindex, '<body');
										
										strip_body_tags($nonindex);

										if ($bodytag)
										{
											// Work around for <body> tags that could contain js with >'s
											preg_match('#<body\s*(\s+\w+\s*=\s*(("|\').*?(?<!\\\)\3))*>#s', $nonindex, $bmatches);  

											$bodycut = strlen($bmatches[0]) + $bodytag;
											$newheader = substr($nonindex, 0, $bodycut);
											$nonindex = substr($nonindex, $bodycut);
										}

										$bodyendcut = strpos($nonindex, '<!--start debug html-->');

										if (!$bodyendcut)
										{
											$bodyendcut = strpos($nonindex, '</body>');
										}

										if ($bodyendcut)
										{
											$nonindex = substr($nonindex, 0, $bodyendcut);
										}

										$nonindex = str_replace(
											array($header, $navbar, $footer, $headinclude, $spacer_open, $spacer_close),
											'',
											$nonindex
										);

										// adv_portal template replacements
										$ptemplate =& $vbulletin->templatecache['adv_portal'];

										$bodytag = strpos($ptemplate, '<body');

										if ($bodytag)
										{
											$bodycut = strpos($ptemplate, '>', $bodytag);
											$ptemplate = substr($ptemplate, $bodycut + 1);
											
											// new javascript in v4.0.8 causes issues
											if ($vbulletin->options['simpleversion'] > 407 AND THIS_SCRIPT == 'member')
											{
												$newheader = str_replace("\\'", "'", $newheader);
											}
											
											$ptemplate = '$final_rendered = \'' . addcslashes($newheader, '\'') . $ptemplate;
										}

										$home[$mods['modid']]['content'] = $nonindex;
									}
								break;

								default:
		            	($hook = vBulletinHook::fetch_hook('vba_cmps_include_switch_pagetype')) ? eval($hook) : false;

							}

						break;

						default:

							($hook = vBulletinHook::fetch_hook('vba_cmps_include_switch_type')) ? eval($hook) : false;

					}

					// Module shell template
					if ($home[$modid]['content'] AND ($mods['useshell'] & $vba_shellint['enable']) AND !$mods['noshell'])
					{
						if ($mods['formcode'])
						{
							eval('$mods[\'formcode\'] = "' . addslashes($mods['formcode']) . '";');
							if (strpos($mods['formcode'], '<form') !== false)
							{
								$show['endform'] = true;
							}
						}

						if ($mods['useshell'] & $vba_shellint['collapse'])
						{
							$mods['collapsestyle'] = 'display: none';
							$mods['collapseimg'] = '_collapsed';
						}
						else
						{
							$mods['collapsestyle'] = $vbcollapse['collapseobj_module_' . $mods['modid']];
							$mods['collapseimg'] = $vbcollapse['collapseimg_module_' . $mods['collapse']];
						}

						$modulehtml = $home[$modid]['content'];
						$templater = vB_Template::create(($mods['altshell'] ? $mods['altshell'] : 'adv_portal_module_wrapper'));
						$templater->register('mods', $mods);
						$templater->register('vba_style', $vba_style);
						$templater->register('modulehtml', $modulehtml);
						$templater->register('vba_shellint', $vba_shellint);

						$home[$mods['modid']]['content'] = $templater->render();
					}

					// Debug
					if ($vbulletin->debug AND $_REQUEST['explain'])
					{
						$finishtime = explode(' ', microtime());
						$finishtime = $finishtime[0] + $finishtime[1] - $scriptstarted;
						$finishqueries = $vbulletin->db->querycount;
						$finishquerytime = $vbulletin->db->time_total;
						$timetaken = $finishtime - $starttime;
						$querytimetaken = $finishquerytime - $startquerytime;

						echo '<div class="explainbody">Time Before: ' . vb_number_format($starttime, 5) . '<br />Time After: ' . vb_number_format($finishtime, 5) . '<br />Time Taken: ' . vb_number_format($timetaken, 5) . '<br /><br />';

						$module_memory_usage = '';
						if ($getmemory)
						{
							$memoryusageend = memory_get_usage();

							echo 'Memory Before: ' . vb_number_format($memoryusagestart / 1024, 3) . ' KB<br />Memory After: ' . vb_number_format($memoryusageend / 1024, 3) . ' KB<br />Memory Used: ' . vb_number_format(($memoryusageend - $memoryusagestart) / 1024, 3) . ' KB<br /><br />';
						}

						echo $processtitle . ' module generated in ' . vb_number_format($timetaken, 5) . ' seconds with ' . ($finishqueries - $startqueries) . ' queries.<br />' . vb_number_format($querytimetaken, 5) . ' seconds doing MySQL queries and ' . vb_number_format($timetaken - $querytimetaken, 5) . ' doing PHP things.</div></div></div><br />';
					}

					if ($show['customizepage'])
					{
						$home[$vba_modcols[$modcol] . 'blocks'] .=  '<li id="licmps_' . $mods['modid'] . '">' . $home[$modid]['content'] . '</li>';
					}
					else
					{
						$home[$vba_modcols[$modcol] . 'blocks'] .= $home[$modid]['content'];
					}

					// make sure the content is set before unsetting, otherwise issues occur with old PHP versions
					if ($home[$modid]['content'])
					{
						unset($home[$modid]['content']);
					}

				}
				
				if ($show['customizepage'])
				{
					$home[$vba_modcols[$modcol] . 'blocks'] = '<ul id="vba_ul_' . $modcol . '" class="draglist">' . $home[$vba_modcols[$modcol] . 'blocks'] . '</ul>';
				}
			}
		}

		unset($forumperms, $mods);
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_print_output')) ? eval($hook) : false;

	$templater = vB_Template::create('adv_portal_footer');
	$templater->register('vba_options', $vba_options);
	$vba_footer = $templater->render();

	$footer = $vba_footer . $footer;

	if ($from_print_output)
	{
		$vbulletin->options['addtemplatename'] = 0;
		$templater = vB_Template::create('adv_portal');
		if (THIS_SCRIPT != 'adv_index' OR $pages['name'] != 'home')
		{
			$templater->register('pagetitle', $pagetitle);
		}
		$templater->register('footer', $footer);
		$templater->register('header', $header);
		$templater->register('headinclude', $headinclude);
		$templater->register('home', $home);
		$templater->register('navbar', $navbar);
		$templater->register('pages', $pages);
		$templater->register('vba_style', $vba_style);
		$output = $templater->render();
		return process_replacement_vars($output);
	}
	else
	{
		// Rebuild the guest homepage cache
		if ($pages['name'] == 'home' AND !$vbulletin->userinfo['userid'] AND $vba_options['portal_guestcache'] AND ($vbulletin->adv_portal_pars['lastupdate'] + $vba_options['portal_guestcache']) <= TIMENOW)
		{
			$homecache = array();
			foreach ($vba_modcols AS $modcol => $modcolname)
			{
				if ($home[$modcolname . 'blocks'])
				{
					$homecache[$modcolname] = 1;
					$homecache[$modcolname . 'blocks'] = $home[$modcolname . 'blocks'];
				}
			}

			build_datastore(
				'adv_portal_pars',
				serialize(array('home' => $homecache, 'lastupdate' => TIMENOW, 'css' => $vba_cssinclude)),
				1
			);
		}

		if ($show['customizepage'])
		{
			$templater = vB_Template::create('adv_portal_dragdrop_headinc');
			$headinclude .= $templater->render();
		}

		define('SKIP_OUTPUT', true);
		$templater = vB_Template::create('adv_portal');
		if ($pages['name'] != 'home')
		{
			$templater->register('pagetitle', $pagetitle);
		}
		$templater->register('home', $home);
		$templater->register('navbar', $navbar);
		$templater->register('pages', $pages);
		$templater->register('vba_style', $vba_style);
		$templater->register_page_templates();
		print_output($templater->render());
	}
}

// ###############################################################################
// End Functions
// ###############################################################################

// ##### Merge the settings
$cmps_options =& $vbulletin->adv_portal_opts;

$portal_options = array_merge($cmps_options['adv_portal_main'], $cmps_options['adv_global']);

if (empty($vba_options))
{
	$vba_options =& $portal_options;
}
else
{
	$vba_options = array_merge($vba_options, $portal_options);
}

$vba_style =& $cmps_options['adv_portal_style'];

$mod_options = array(); // set here so it can be globalized in functions

require_once(DIR . '/includes/vba_cmps_global.php');


// Meta tags
if ($pages['meta']['description'])
{
	$vbulletin->options['description'] = $pages['meta']['description'];
}
if ($pages['meta']['keywords'])
{
	$vbulletin->options['keywords'] = $pages['meta']['keywords'];
}

// Check user's groups against page permissions
$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

// ##### Forum Permissions - set here so the variables are globalized
$allowview = false;
$adv_forumperms = array();
$adv_canviewforums = array();
$adv_canviewforumscontent = array();
$forumperms_query = '';

if ($pages['userperms'])
{
	$allowview = (array_intersect($vbulletin->userinfo['usergrouparray'], $pages['userperms'])) ? true : false;
}

// ##### Check page permissions
if (!$allowview OR !$pages['pageid'] OR $pages['forceredirect'])
{
	if (!$pages['pageid'])
	{
		eval(standard_error(fetch_error('invalid_page_specified')));
	}
	else if ($pages['forceredirect'])
	{
		$vbulletin->url = $_SERVER['REQUEST_URI'];
		standard_redirect(fetch_error($pages['forceredirect']), true);
	}
	else
	{
		$navbar = render_navbar_template(construct_navbits($navbits));
		print_no_permission();
	}
}

define(
	'USE_VBA_HOMECACHE',
	($pages['name'] == 'home' AND !$vbulletin->userinfo['userid'] AND $vba_options['portal_guestcache'] AND $vbulletin->adv_portal_pars['lastupdate'] + $vba_options['portal_guestcache'] >= TIMENOW ? true : false)
);

if ($vbulletin->userinfo['cmpslayout'])
{
	$pages['defaultlayout'] = $pages['modules']; // keep a record here to compare below
	$pages['modules'] = unserialize($vbulletin->userinfo['cmpslayout']);
}

if (USE_VBA_HOMECACHE)
{
	$home =& $vbulletin->adv_portal_pars['home'];
	$vba_cssinclude =& $vbulletin->adv_portal_pars['css'];

	foreach ($home AS $pagecol => $colcontent)
	{
		$show[$pagecol . '_column'] = true;
	}
}
else
{
	unset($vbulletin->adv_portal_pars);

	$modules = array();
	$modules_noperms = array();
	$vba_cssinclude = array();
	$vba_dyna_inst = array();
	$vba_dyna_temps = array();
	$vba_initload = 0;
	$vba_cusmodid = 0;

	// Init vBa Dynamics
	if ($initialize_dynamics)
	{
		// Clear special templates and keep a record for do_db_fetch() function below
		$oldspecial = $specialtemplates;
		$specialtemplates = array();
		require_once('./includes/vba_dyna_include_prefix.php');
	}

	// Sort through the modules to get the $globaltemplates and check perms
	if (!empty($pages['modules']))
	{
		foreach ($pages['modules'] AS $pagecol => $pagemodules)
		{
			if (!empty($pagemodules))
			{
				foreach ($pagemodules AS $advmodid => $advmodorder)
				{
					$vba_mod =& $vbulletin->adv_modules[$advmodid];

					// Check permissions
					if (!can_view_cmps_mod($vba_mod))
					{
						unset($pages['modules'][$pagecol][$advmodid]);
						$modules_noperms[] = $advmodid;
						continue;
					}
					// Custom Page Conent module
					else if ($vba_mod['inctype'] == 'custom')
					{
						$vba_cusmodid = $advmodid;
					}
					// Dynamics modules
					else if ($vba_mod['dyna_prefix'])
					{
						// fallback incase this is a custom layout and the default
						// no longer has dynamics modules active
						if (!$initialize_dynamics)
						{
							$initialize_dynamics = true;
					
							// Clear special templates and keep a record for do_db_fetch() function below
							$oldspecial = $specialtemplates;
							$specialtemplates = array();
							require_once('./includes/vba_dyna_include_prefix.php');
						}
						
						$vba_dyna_inst[] = $vba_mod['dyna_prefix'];
						$vba_cssinclude[] = $vba_mod['dyna_prefix'] . '.css';
						
						if ($vba_mod['inctype'] == 'php_file' AND !empty($vba_mod['templatelist']))
						{
							if ($vba_mod['dyna_prefix'] != 'adv_dyna')
							{
								$newdynatemps = array();
						
								foreach ($vba_mod['templatelist'] AS $newtemp)
								{
									$newdynatemps[] = check_prefix($newtemp, $vba_mod['dyna_prefix']);
								}
								$vba_mod['templatelist'] = $newdynatemps;
							}
							
							$vba_dyna_temps = array_merge($vba_dyna_temps, $vba_mod['templatelist']);
						}
						else if ($vba_mod['inctype'] == 'template' AND $vba_mod['filename'])
						{
							$vba_mod['filename'] = check_prefix($vba_mod['filename'], $vba_mod['dyna_prefix']);
							
							$vba_dyna_temps[] = check_prefix('adv_dyna_' . $mod['filename']);
						}
					}

					// CSS files
					if ($vba_mod['cssfiles'])
					{
						$vba_cssinclude = array_merge($vba_cssinclude, $vba_mod['cssfiles']);
					}

					// Need an array of nothing but ids for the news/archive and online/buddy modules
					$modules[] = $advmodid;
					construct_global_templates($vba_mod);

					// Needs to be set at least for the news archive so we know which column we're dealing with
					$vba_mod['modcol'] = $pagecol;

					// Initialize variables
					$vba_initload |= $vba_mod['options'];

					($hook = vBulletinHook::fetch_hook('vba_cmps_include_preprocess_modules')) ? eval($hook) : false;
				}

				if (!empty($pages['modules'][$pagecol]))
				{
					$show[$vba_modcols[$pagecol] . '_column'] = true;
				}
			}
		}
	}

	// More global templates
	if ($pages['type'] == 'bb_code')
	{
		$vba_initload |= $vba_php_modint['load_bbcode_parser'];

		$bootstrap->cache_templates[] = 'bbcode_quote';
		$bootstrap->cache_templates[] = 'bbcode_php';
		$bootstrap->cache_templates[] = 'bbcode_code';
	}

	$bootstrap->cache_templates[] = 'adv_portal_module_wrapper';

	if ($pages['template'])
	{
		$bootstrap->cache_templates[] = $pages['template'];
	}
	
	// Init vBa Dynamics
	if ($initialize_dynamics)
	{
		if (!empty($vba_dyna_inst))
		{
			// only $specialtemplates was set before v1.2.1 (added later in 1.2.0)
			$dyna_special_temp_default = (is_array($dyna_specialtemplates)) ? $dyna_specialtemplates : $specialtemplates;

			$dyna_special_temp = array();
			foreach ($vba_dyna_inst AS $dyna_instance)
			{
				foreach ($dyna_special_temp_default AS $spectemp)
				{
					$dyna_special_temp[] = check_prefix($spectemp, $dyna_instance);
				}
			}

			$vbulletin->datastore->do_db_fetch("'" . implode("','", $dyna_special_temp) . "'");

			// Need to set a copy of default Dynamics special templates since
			// convert_prefixed_datastore() could destroy the original values
			if (sizeof($vba_dyna_inst) > 1)
			{
				foreach ($dyna_special_temp_default AS $dyna_tempname)
				{
					$dyna_default[$dyna_tempname] = $vbulletin->$dyna_tempname;
				}
			}

			require_once(DIR . '/includes/vba_dyna_class.php');
			require_once(DIR . '/includes/vba_dyna_functions.php');

			// Init the main Dynamics instance
			$vba_dyna = new vBa_dyna();
			$vba_dyna->vbulletin =& $vbulletin;
			$vba_dyna->prefix = 'adv_dyna';
			$vba_dyna->tableprefix = TABLE_PREFIX . $vba_dyna->prefix . '_';

			if (in_array('adv_dyna', $vba_dyna_inst))
			{
				$vba_options = array_merge($vba_options, $vbulletin->adv_dyna_opts);
				$vba_options['dyna_lightbox'] = false; // disable the lightbox since it'll point to vB's attachment.php

				fetch_option_phrases();

				$vba_dyna->default_permissions();
				$vba_dyna->fetch_category_perms();
			}
		}

		$specialtemplates = $oldspecial; // reset $specialtemplates
	}
}

// The page was updated since this user last visited, so compare the layout
if ($vbulletin->userinfo['cmpslayout'] AND $vbulletin->userinfo['userlayoutdateline'] < $pages['dateline'])
{
	$moddefcmp = array();
	foreach ($pages['defaultlayout'] AS $pmodcol => $pmods)
	{
		$moddefcmp = array_merge($moddefcmp, array_keys($pmods));
	}

	$updatelayout = false;
	$pages['forceredirect'] = false;

	$removedmods = array_diff(array_merge($modules, $modules_noperms), $moddefcmp);
	// Modules have been disabled in the default layout
	if (!empty($removedmods))
	{
		$updatelayout = true;
		$pages['forceredirect'] = 'adv_portal_old_modules_found';
		foreach ($vba_modcols AS $modcol => $modcolname)
		{
			if (!empty($pages['modules'][$modcol]))
			{
				$newcol = array_diff(array_keys($pages['modules'][$modcol]), $removedmods);
				$pages['modules'][$modcol] = array_combine($newcol, range(1, sizeof($newcol)));
			}
		}
	}

	$mdiff = array_diff($moddefcmp, array_merge($modules, $modules_noperms));

	// We have missing modules, so add them
	if (!empty($mdiff))
	{
		$maxorder = max(array_values($pages['modules']['2']));

		foreach ($mdiff AS $modid)
		{
			$maxorder += 1;
			$pages['modules']['2'][$modid] = $maxorder;
			$updatelayout = true;

			if (can_view_cmps_mod($vbulletin->adv_modules[$modid]))
			{
				$pages['forceredirect'] = 'adv_portal_required_modules_not_found';
			}
		}
	}

	if ($updatelayout)
	{
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "adv_pages_user
				(pageid, userid, layout, dateline)
			VALUES (
				" . $pages['pageid'] . ",
				" . $vbulletin->userinfo['userid'] . ",
				'" . $db->escape_string(serialize($pages['modules'])) . "',
				" . TIMENOW . "
		)");

		// redirect later once the templates are available
	}
	else
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_pages_user SET
				dateline = " . TIMENOW . "
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
				AND pageid = $pages[pageid]
		");
	}
}

// ##### BB code parser
if ($vba_initload & $vba_php_modint['load_bbcode_parser'])
{
	require_once(DIR . '/includes/class_bbcode.php');

	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$bbcode_parser->tag_list['no_option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);
	$bbcode_parser->tag_list['no_option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);
	$bbcode_parser->tag_list['option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
	$bbcode_parser->tag_list['option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
	$bbcode_parser->unsetattach = true;
}

// ##### Moderators
if ($vba_initload & $vba_php_modint['load_moderators'])
{
	require_once(DIR . '/includes/functions_forumlist.php');
	cache_moderators();
}

// ##### Forum Permissions
if ($vba_initload & $vba_php_modint['load_forum_perms'])
{
	foreach ($vbulletin->forumcache AS $fid => $finfo)
	{
		$adv_forumperms[$finfo['forumid']] = fetch_permissions($finfo['forumid']);

		if (!$finfo['forumid'])
		{
			continue;
		}

		$passperms = verify_forum_password($finfo['forumid'], $finfo['password'], false);

		if (!$passperms OR !($adv_forumperms[$finfo['forumid']] & $vbulletin->bf_ugp_forumpermissions['canviewthreads']) OR !($adv_forumperms[$finfo['forumid']] & $vbulletin->bf_ugp_forumpermissions['canviewothers']))
		{
			$adv_canviewforums[] = $finfo['forumid'];
		}
		if (!$passperms OR !($adv_forumperms[$finfo['forumid']] & $vbulletin->bf_ugp_forumpermissions['canview']))
		{
			$adv_canviewforumscontent[] = $finfo['forumid'];
		}
	}

	if (!empty($adv_canviewforums))
	{
		$forumperms_query = 'AND thread.forumid NOT IN(' . implode(',', $adv_canviewforums) .')';
	}
}

// ##### Get tachied / ignored users
if ($vba_initload & $vba_php_modint['load_ignusers'])
{
	require_once(DIR . '/includes/functions_bigthree.php');

	$ignusers = fetch_coventry();

	if ($vbulletin->userinfo['ignorelist'])
	{
		$ignusers = array_merge($ignusers, explode(' ', trim($vbulletin->userinfo['ignorelist'])));
	}

	if (!empty($ignusers))
	{
		$ignusers = implode(',', $ignusers);
	}
}

?>